#!/bin/bash

if [ "$DBG" = 1 ]; then
    export DBG=' -m ptvsd --host 0.0.0.0 --port 5678 --wait '
        EXP=dbg
        BSZ=1250 #20
else
    BSZ=1250 #230
fi


export CUDA_VISIBLE_DEVICES=$(get_free_gpu.sh)
echo "CUDA_VISIBLE_DEVICES:" $CUDA_VISIBLE_DEVICES

hostname=$(hostname)
if [ "$hostname" == "brains" ]; then
    # Rotate the CUDA_VISIBLE_DEVICES environment variable
    export CUDA_VISIBLE_DEVICES=$(echo $CUDA_VISIBLE_DEVICES | tr '0123' '2301')
    echo "Map CUDA_VISIBLE_DEVICES:" $CUDA_VISIBLE_DEVICES 
fi

export usermode=$1
export extramode=$2

METHOD="openai"

python $DBG main_watermark.py --model_name guanaco-7b --prompt_type guanaco --prompt_path data/alpaca_data.json --nsamples 3216 --batch_size 32 --method $METHOD --temperature 1.0 --seeding hash --ngram 2 --method_detect $METHOD --scoring_method v2 --payload 0 --payload_max 4 --output_dir output/exps/